/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class BenthicAnomalyEffect
extends OneShotEffect {
    BenthicAnomalyEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, choose a creature that player controls. Create a token that's a copy of one of those creatures, except its power is equal to the total power of those creatures, its toughness is equal to the total toughness of those creatures, and it's a colorless Eldrazi creature";
    }

    private BenthicAnomalyEffect(BenthicAnomalyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BenthicAnomalyEffect copy() {
        return new BenthicAnomalyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature controlled by " + opponent.getName());
            filter.add((Predicate)new ControllerIdPredicate(opponentId));
            if (!game.getBattlefield().contains((FilterPermanent)filter, source, game, 1)) continue;
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent2 = game.getPermanent(target.getFirstTarget());
            if (permanent2 == null) continue;
            permanents.add(permanent2);
        }
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                permanent = (Permanent)RandomUtil.randomFromCollection(permanents);
                break;
            }
            default: {
                FilterPermanent filter = new FilterPermanent("a creature to create a copy of");
                filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                permanent = game.getPermanent(target.getFirstTarget());
            }
        }
        int power = permanents.stream().map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        int toughness = permanents.stream().map(MageObject::getToughness).mapToInt(MageInt::getValue).sum();
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, false, false, null, power, toughness, false);
        return effect.setSavedPermanent(permanent).setOnlyColor(ObjectColor.COLORLESS).setOnlySubType(SubType.ELDRAZI).apply(game, source);
    }
}

