/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.condition.common.BargainedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class BeseechTheMirrorEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    BeseechTheMirrorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a card, exile it face down, then shuffle. If this spell was bargained, you may cast the exiled card without paying its mana cost if that spell's mana value is 4 or less. Put the exiled card into your hand if it wasn't cast this way.";
    }

    private BeseechTheMirrorEffect(BeseechTheMirrorEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeseechTheMirrorEffect copy() {
        return new BeseechTheMirrorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        if (controller.searchLibrary(target, source, game) && (card = controller.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
            card.setFaceDown(true, game);
            controller.moveCards(card, Zone.EXILED, source, game, false, true, false, null);
            card.setFaceDown(true, game);
            controller.shuffleLibrary(source, game);
            if (BargainedCondition.instance.apply(game, source)) {
                CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card, (FilterCard)filter);
            }
            game.processAction();
            if (game.getState().getZone(card.getId()).equals((Object)Zone.EXILED)) {
                controller.moveCards(card, Zone.HAND, source, game, false, true, false, null);
                card.setFaceDown(false, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, 4));
    }
}

