/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.NextSpellCastHasAbilityEffect;
import mage.abilities.effects.mana.AddManaOfAnyColorEffect;
import mage.abilities.keyword.CascadeAbility;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BiggerOnTheInsideEffect
extends OneShotEffect {
    BiggerOnTheInsideEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player adds two mana of any one color. The next spell they cast this turn has cascade";
    }

    private BiggerOnTheInsideEffect(BiggerOnTheInsideEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiggerOnTheInsideEffect copy() {
        return new BiggerOnTheInsideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        NextSpellCastHasAbilityEffect cascadeEffect = new NextSpellCastHasAbilityEffect((Ability)new CascadeAbility(), StaticFilters.FILTER_CARD, TargetController.SOURCE_TARGETS);
        game.addEffect((ContinuousEffect)cascadeEffect, source);
        AddManaOfAnyColorEffect manaEffect = new AddManaOfAnyColorEffect(2);
        Mana manaToAdd = manaEffect.produceMana(game, source);
        if (manaToAdd != null && manaToAdd.count() > 0) {
            player.getManaPool().addMana(manaToAdd, game, source);
        }
        return true;
    }
}

