/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BileBlightEffect
extends BoostAllEffect {
    BileBlightEffect() {
        super(-3, -3, Duration.EndOfTurn);
        this.staticText = "Target creature and all other creatures with the same name as that creature get -3/-3 until end of turn";
    }

    private BileBlightEffect(BileBlightEffect effect) {
        super((BoostAllEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.clear();
        if (!this.getAffectedObjectsSet()) {
            return;
        }
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null) {
            return;
        }
        if (CardUtil.haveEmptyName((MageObject)target)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)target, game));
            return;
        }
        String name = target.getName();
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (!CardUtil.haveSameNames((MageObject)perm, (String)name, (Game)game)) continue;
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public BileBlightEffect copy() {
        return new BileBlightEffect(this);
    }
}

