/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.RemoveFromCombatSourceEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BillFernyEffect
extends OneShotEffect {
    private static final Effect create3TreasureTokens = new CreateTokenEffect((Token)new TreasureToken(), 3);
    private static final Effect removeFromCombat = new RemoveFromCombatSourceEffect();

    BillFernyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent gains control of target Horse you control. If they do, remove Bill Ferny from combat and create three Treasure tokens.";
    }

    private BillFernyEffect(BillFernyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BillFernyEffect copy() {
        return new BillFernyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (permanent == null) {
            return false;
        }
        UUID opponentToGainControl = this.getTargetPointer().getFirst(game, source);
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, opponentToGainControl).setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game)), source);
        game.processAction();
        if (permanent.isControlledBy(opponentToGainControl)) {
            removeFromCombat.apply(game, source);
            create3TreasureTokens.apply(game, source);
            return true;
        }
        return false;
    }
}

