/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class BingoEffect
extends OneShotEffect {
    BingoEffect() {
        super(Outcome.Neutral);
        this.staticText = "put a chip counter on its mana value";
    }

    private BingoEffect(BingoEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            if (spell.getManaValue() > 9) {
                return true;
            }
            MageObject mageObject = game.getObject(source);
            if (mageObject != null) {
                HashMap<Integer, Integer> chipCounters = new HashMap<Integer, Integer>();
                if (game.getState().getValue(mageObject.getId() + "_chip") != null) {
                    chipCounters.putAll((Map)game.getState().getValue(mageObject.getId() + "_chip"));
                }
                chipCounters.putIfAbsent(spell.getManaValue(), 0);
                chipCounters.put(spell.getManaValue(), (Integer)chipCounters.get(spell.getManaValue()) + 1);
                game.getState().setValue(mageObject.getId() + "_chip", chipCounters);
                if (mageObject instanceof Permanent) {
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    for (Map.Entry entry : chipCounters.entrySet()) {
                        sb.append(entry.getKey());
                        if (++i >= chipCounters.size()) continue;
                        sb.append(", ");
                    }
                    ((Permanent)mageObject).addInfo("chip counters", CardUtil.addToolTipMarkTags((String)("Chip counters at: " + sb)), game);
                    new AddCountersSourceEffect(CounterType.CHIP.createInstance()).apply(game, source);
                }
                return true;
            }
        }
        return false;
    }

    public BingoEffect copy() {
        return new BingoEffect(this);
    }
}

