/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.b.BioengineeredFutureWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BioengineeredFutureEffect
extends ReplacementEffectImpl {
    BioengineeredFutureEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "each creature you control enters with an additional +1/+1 counter on it for each land that entered the battlefield under your control this turn";
    }

    private BioengineeredFutureEffect(BioengineeredFutureEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BioengineeredFutureEffect copy() {
        return new BioengineeredFutureEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        int count = BioengineeredFutureWatcher.getCount(game, source);
        if (creature != null && count > 0) {
            creature.addCounters(CounterType.P1P1.createInstance(count), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }
}

