/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BiolumeEggEffect
extends OneShotEffect {
    BiolumeEggEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control";
    }

    private BiolumeEggEffect(BiolumeEggEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiolumeEggEffect copy() {
        return new BiolumeEggEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            game.getState().setValue("EnterTransformed" + card.getId(), (Object)Boolean.TRUE);
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

