/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BiomancersFamiliarCostReductionEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Activated abilities of creatures you control cost {2} less to activate. This effect can't reduce the mana in that cost to less than one mana";

    BiomancersFamiliarCostReductionEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = effectText;
    }

    private BiomancersFamiliarCostReductionEffect(BiomancersFamiliarCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller == null) {
            return false;
        }
        int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)2, (int)1);
        if (reduceMax <= 0) {
            return true;
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.getAbilityType().isActivatedAbility()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(abilityToModify.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId());
    }

    public BiomancersFamiliarCostReductionEffect copy() {
        return new BiomancersFamiliarCostReductionEffect(this);
    }
}

