/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BishopOfBindingExileEffect
extends OneShotEffect {
    BishopOfBindingExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target creature an opponent controls until {this} leaves the battlefield";
    }

    private BishopOfBindingExileEffect(BishopOfBindingExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public BishopOfBindingExileEffect copy() {
        return new BishopOfBindingExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            new ExileTargetEffect(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), permanent.getIdName()).apply(game, source);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
            return true;
        }
        return false;
    }
}

