/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostOpponentsEffect;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

class BiteOfTheBlackRoseEffect
extends OneShotEffect {
    BiteOfTheBlackRoseEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Will of the council</i> &mdash; Starting with you, each player votes for sickness or psychosis. If sickness gets more votes, creatures your opponents control get -2/-2 until end of turn. If psychosis gets more votes or the vote is tied, each opponent discards two cards";
    }

    private BiteOfTheBlackRoseEffect(BiteOfTheBlackRoseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BiteOfTheBlackRoseEffect copy() {
        return new BiteOfTheBlackRoseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Sickness (-2/-2)", "Psychosis (discard cards)", Outcome.Detriment);
        vote.doVotes(source, game);
        int sicknessCount = vote.getVoteCount((Object)true);
        int psychosisCount = vote.getVoteCount((Object)false);
        if (sicknessCount > psychosisCount) {
            game.addEffect((ContinuousEffect)new BoostOpponentsEffect(-2, -2, Duration.EndOfTurn), source);
        } else {
            new DiscardEachPlayerEffect((DynamicValue)StaticValue.get((int)2), false, TargetController.OPPONENT).apply(game, source);
        }
        return true;
    }
}

