/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlackMarketEffect
extends OneShotEffect {
    BlackMarketEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "add {B} for each charge counter on {this}";
    }

    private BlackMarketEffect(BlackMarketEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackMarketEffect copy() {
        return new BlackMarketEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (sourcePermanent != null && player != null) {
            int chargeCounters = sourcePermanent.getCounters(game).getCount(CounterType.CHARGE);
            if (chargeCounters > 0) {
                player.getManaPool().addMana(Mana.BlackMana((int)chargeCounters), game, source);
            }
            return true;
        }
        return false;
    }
}

