/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BlackViseEffect
extends OneShotEffect {
    BlackViseEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals X damage to that player, where X is the number of cards in their hand minus 4";
    }

    private BlackViseEffect(BlackViseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackViseEffect copy() {
        return new BlackViseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID playerId = (UUID)game.getState().getValue(source.getSourceId().toString() + "_opponent");
        Player chosenPlayer = game.getPlayer(playerId);
        if (chosenPlayer != null) {
            int damage = chosenPlayer.getHand().size() - 4;
            if (damage > 0) {
                chosenPlayer.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

