/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BlacksmithsSkillEffect
extends OneShotEffect {
    BlacksmithsSkillEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's an artifact creature, it gets +2/+2 until end of turn";
    }

    private BlacksmithsSkillEffect(BlacksmithsSkillEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlacksmithsSkillEffect copy() {
        return new BlacksmithsSkillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.isArtifact(game) && permanent.isCreature(game)) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2), source);
            return true;
        }
        return false;
    }
}

