/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class BlastOfGeniusEffect
extends OneShotEffect {
    BlastOfGeniusEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose any target. Draw three cards, then discard a card. {this} deals damage equal to the discard card's mana value to that permanent or player";
    }

    private BlastOfGeniusEffect(BlastOfGeniusEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlastOfGeniusEffect copy() {
        return new BlastOfGeniusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(3, source, game);
            TargetDiscard target = new TargetDiscard(player.getId());
            if (target.canChoose(player.getId(), source, game)) {
                player.choose(Outcome.Discard, (Target)target, source, game);
                Card card = player.getHand().get(target.getFirstTarget(), game);
                if (card != null) {
                    player.discard(card, false, source, game);
                    int damage = card.getManaValue();
                    Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                    if (creature != null) {
                        creature.damage(damage, source.getSourceId(), source, game, false, true);
                        return true;
                    }
                    Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                    if (targetPlayer != null) {
                        targetPlayer.damage(damage, source.getSourceId(), source, game);
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

