/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BlazeOfGloryRequirementEffect
extends RequirementEffect {
    BlazeOfGloryRequirementEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "It blocks each attacking creature this turn if able";
    }

    private BlazeOfGloryRequirementEffect(BlazeOfGloryRequirementEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public boolean mustBlockAllAttackers(Game game) {
        return true;
    }

    public BlazeOfGloryRequirementEffect copy() {
        return new BlazeOfGloryRequirementEffect(this);
    }
}

