/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlazingSunsteelEffect
extends OneShotEffect {
    BlazingSunsteelEffect() {
        super(Outcome.Benefit);
    }

    private BlazingSunsteelEffect(BlazingSunsteelEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlazingSunsteelEffect copy() {
        return new BlazingSunsteelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanentOrLKIBattlefield((UUID)this.getValue("equipped"));
        Integer damage = (Integer)this.getValue("damage");
        if (creature == null || damage == null || damage < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            permanent.damage(damage.intValue(), creature.getId(), source, game);
            return true;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            player.damage(damage.intValue(), creature.getId(), source, game);
            return true;
        }
        return false;
    }
}

