/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BleedingEffectEffect
extends OneShotEffect {
    private static final List<Class<? extends Ability>> abilities = Arrays.asList(FlyingAbility.class, FirstStrikeAbility.class, DoubleStrikeAbility.class, DeathtouchAbility.class, HexproofBaseAbility.class, IndestructibleAbility.class, LifelinkAbility.class, MenaceAbility.class, ReachAbility.class, TrampleAbility.class, ReachAbility.class, TrampleAbility.class, VigilanceAbility.class);

    BleedingEffectEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "creatures you control gain flying until end of turn if a creature card in your graveyard has flying. The same is true for first strike, double strike, deathtouch, hexproof, indestructible, lifelink, menace, reach, trample, and vigilance.";
    }

    private BleedingEffectEffect(BleedingEffectEffect effect) {
        super((OneShotEffect)effect);
    }

    public BleedingEffectEffect copy() {
        return new BleedingEffectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MenaceAbility menaceAbility = new MenaceAbility(false);
        controller.getGraveyard().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).flatMap(c -> c.getAbilities(game).stream()).filter(a -> abilities.stream().anyMatch(x -> x.isInstance(a))).map(arg_0 -> BleedingEffectEffect.lambda$apply$3((Ability)menaceAbility, arg_0)).distinct().forEach(a -> game.addEffect((ContinuousEffect)new GainAbilityControlledEffect(a, Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES), source));
        return true;
    }

    private static /* synthetic */ Ability lambda$apply$3(Ability menaceAbility, Ability a) {
        return a instanceof MenaceAbility ? menaceAbility : a.copy();
    }
}

