/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class BlessedReincarnationEffect
extends OneShotEffect {
    BlessedReincarnationEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile target creature an opponent controls. That player reveals cards from the top of their library until a creature card is revealed. The player puts that card onto the battlefield, then shuffles the rest into their library";
    }

    private BlessedReincarnationEffect(BlessedReincarnationEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlessedReincarnationEffect copy() {
        return new BlessedReincarnationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && controller != null) {
            Library library;
            controller.moveCards((Card)permanent, Zone.EXILED, source, game);
            game.processAction();
            Player permanentController = game.getPlayer(permanent.getControllerId());
            if (permanentController != null && (library = permanentController.getLibrary()).hasCards()) {
                CardsImpl toReveal = new CardsImpl();
                for (Card card : library.getCards(game)) {
                    toReveal.add(card);
                    if (!card.isCreature(game)) continue;
                    permanentController.moveCards(card, Zone.BATTLEFIELD, source, game);
                    break;
                }
                permanentController.revealCards(source, (Cards)toReveal, game);
                if (toReveal.size() > 1) {
                    permanentController.shuffleLibrary(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

