/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCreaturePermanentAmount;
import mage.watchers.common.ManaPaidSourceWatcher;

class BlessingOfFrostEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    BlessingOfFrostEffect() {
        super(Outcome.Benefit);
        this.staticText = "Distribute X +1/+1 counters among any number of creatures you control, where X is the amount of {S} spent to cast this spell. Then draw a card for each creature you control with power 4 or greater.";
    }

    private BlessingOfFrostEffect(BlessingOfFrostEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlessingOfFrostEffect copy() {
        return new BlessingOfFrostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int snow = ManaPaidSourceWatcher.getSnowPaid((UUID)source.getId(), (Game)game);
        int potentialTarget = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game);
        if (snow > 0 && potentialTarget > 0) {
            TargetCreaturePermanentAmount target = new TargetCreaturePermanentAmount(snow, 0, snow, StaticFilters.FILTER_CONTROLLED_CREATURE);
            target.withNotTarget(true);
            target.chooseTarget(this.outcome, player.getId(), source, game);
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                permanent.addCounters(CounterType.P1P1.createInstance(target.getTargetAmount(targetId)), source.getControllerId(), source, game);
            }
        }
        game.processAction();
        player.drawCards(game.getBattlefield().count(filter, source.getControllerId(), source, game), source, game);
        return true;
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
    }
}

