/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.token.EldraziScionToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class BlightHerderEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards your opponents own from exile");

    public BlightHerderEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put two cards your opponents own from exile into their owners' graveyards. If you do, create three 1/1 colorless Eldrazi Scion creature tokens. They have \"Sacrifice this creature: Add {C}.";
    }

    private BlightHerderEffect(BlightHerderEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlightHerderEffect copy() {
        return new BlightHerderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInExile target = new TargetCardInExile(2, 2, filter);
            if (target.canChoose(source.getControllerId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                CardsImpl cardsToGraveyard = new CardsImpl((Collection)target.getTargets());
                controller.moveCards((Cards)cardsToGraveyard, Zone.GRAVEYARD, source, game);
                return new CreateTokenEffect((Token)new EldraziScionToken(), 3).apply(game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
    }
}

