/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.PreventDamageAndRemoveCountersEffect;
import mage.abilities.effects.common.counter.AddCountersPlayersEffect;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class BloatflySwarmPreventionEffect
extends PreventDamageAndRemoveCountersEffect {
    BloatflySwarmPreventionEffect() {
        super(true, true, true);
        this.staticText = "If damage would be dealt to {this} while it has a +1/+1 counter on it, prevent that damage, remove that many +1/+1 counters from it, then give each player a rad counter for each +1/+1 counter removed this way";
    }

    private BloatflySwarmPreventionEffect(BloatflySwarmPreventionEffect effect) {
        super((PreventDamageAndRemoveCountersEffect)effect);
    }

    public BloatflySwarmPreventionEffect copy() {
        return new BloatflySwarmPreventionEffect(this);
    }

    protected void onDamagePrevented(GameEvent event, Ability source, Game game, int amountRemovedInTotal, int amountRemovedThisTime) {
        super.onDamagePrevented(event, source, game, amountRemovedInTotal, amountRemovedThisTime);
        new AddCountersPlayersEffect(CounterType.RAD.createInstance(amountRemovedThisTime), TargetController.EACH_PLAYER).apply(game, source);
    }
}

