/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.TreasureToken;

class BloodMoneyEffect
extends OneShotEffect {
    BloodMoneyEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy all creatures. For each nontoken creature destroyed this way, you create a tapped Treasure token";
    }

    private BloodMoneyEffect(BloodMoneyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodMoneyEffect copy() {
        return new BloodMoneyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (!permanent.destroy(source, game) || permanent instanceof PermanentToken) continue;
            ++count;
        }
        if (count > 0) {
            new TreasureToken().putOntoBattlefield(count, game, source, source.getControllerId(), true, false);
        }
        return true;
    }
}

