/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BloodOfTheMartyrEffect
extends ReplacementEffectImpl {
    BloodOfTheMartyrEffect() {
        super(Duration.EndOfTurn, Outcome.RedirectDamage);
        this.staticText = "Until end of turn, if damage would be dealt to any creature, you may have that damage dealt to you instead";
    }

    private BloodOfTheMartyrEffect(BloodOfTheMartyrEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BloodOfTheMartyrEffect copy() {
        return new BloodOfTheMartyrEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        DamageEvent damageEvent = (DamageEvent)event;
        if (controller != null) {
            controller.damage(damageEvent.getAmount(), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), damageEvent.getAppliedEffects());
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        DamageEvent damageEvent = (DamageEvent)event;
        return controller != null && permanent != null && permanent.isCreature(game) && controller.chooseUse(this.outcome, "Have " + damageEvent.getAmount() + " damage dealt to you instead of " + permanent.getLogName() + "?", source, game);
    }
}

