/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BloodSunEffect
extends ContinuousEffectImpl {
    BloodSunEffect(Duration duration) {
        super(duration, Outcome.LoseAbility);
        this.staticText = "all lands lose all abilities except mana abilities";
    }

    private BloodSunEffect(BloodSunEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BloodSunEffect copy() {
        return new BloodSunEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, player.getId(), source, game)) {
                switch (layer) {
                    case AbilityAddingRemovingEffects_6: {
                        ArrayList toRemove = new ArrayList();
                        permanent.getAbilities().forEach(ability -> {
                            if (!ability.getAbilityType().isManaAbility()) {
                                toRemove.add(ability);
                            }
                        });
                        permanent.removeAbilities(toRemove, source.getSourceId(), game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

