/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.CreateTokenCopySourceEffect;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BloodforgedBattleAxeAbility
extends TriggeredAbilityImpl {
    public BloodforgedBattleAxeAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenCopySourceEffect());
    }

    private BloodforgedBattleAxeAbility(BloodforgedBattleAxeAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BloodforgedBattleAxeAbility copy() {
        return new BloodforgedBattleAxeAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, create a token that's a copy of {this}.";
    }
}

