/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BloodletterEffect
extends OneShotEffect {
    BloodletterEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice {this}. If you do, it deals 2 damage to each creature and each player";
    }

    private BloodletterEffect(BloodletterEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodletterEffect copy() {
        return new BloodletterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.sacrifice(source, game)) {
            return new DamageEverythingEffect(2).apply(game, source);
        }
        return false;
    }
}

