/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.BloodthirstAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class BloodlordOfVaasgothEffect
extends ContinuousEffectImpl {
    private Ability ability = new BloodthirstAbility(3);
    private int zoneChangeCounter;
    private UUID permanentId;

    BloodlordOfVaasgothEffect() {
        super(Duration.OneUse, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "it gains bloodthirst 3";
    }

    private BloodlordOfVaasgothEffect(BloodlordOfVaasgothEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.ability = effect.ability.copy();
        this.zoneChangeCounter = effect.zoneChangeCounter;
        this.permanentId = effect.permanentId;
    }

    public BloodlordOfVaasgothEffect copy() {
        return new BloodlordOfVaasgothEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Spell object = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (object != null) {
            this.zoneChangeCounter = game.getState().getZoneChangeCounter(object.getSourceId()) + 1;
            this.permanentId = object.getSourceId();
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.permanentId);
        if (permanent != null && permanent.getZoneChangeCounter(game) <= this.zoneChangeCounter) {
            permanent.addAbility(this.ability, source.getSourceId(), game);
        } else {
            Spell spell;
            if (game.getState().getZoneChangeCounter(this.permanentId) >= this.zoneChangeCounter) {
                this.discard();
            }
            if ((spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source))) != null) {
                game.getState().addOtherAbility(spell.getCard(), this.ability, true);
            }
        }
        return true;
    }
}

