/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.b.BloodthirstyAdversaryCopyEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class BloodthirstyAdversaryEffect
extends OneShotEffect {
    private static final FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant and/or sorcery cards with mana value 3 or less from your graveyard");

    public BloodthirstyAdversaryEffect() {
        super(Outcome.Benefit);
        this.staticText = "put that many +1/+1 counters on {this}, then exile up to that many target instant and/or sorcery cards with mana value 3 or less from your graveyard and copy them. You may cast any number of the copies without paying their mana costs";
    }

    private BloodthirstyAdversaryEffect(BloodthirstyAdversaryEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodthirstyAdversaryEffect copy() {
        return new BloodthirstyAdversaryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer timesPaid = (Integer)this.getValue("timesPaid");
        if (timesPaid == null || timesPaid <= 0) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(timesPaid.intValue())), false, this.staticText);
        ability.addEffect((Effect)new BloodthirstyAdversaryCopyEffect());
        ability.addTarget((Target)new TargetCardInYourGraveyard(0, timesPaid.intValue(), (FilterCard)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

