/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class BlotOutEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("creature or planeswalker you control with the greatest mana value");

    BlotOutEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent exiles a creature or planeswalker they control with the greatest mana value among creatures and planeswalkers they control";
    }

    private BlotOutEffect(BlotOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlotOutEffect copy() {
        return new BlotOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null || game.getBattlefield().count(StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_PLANESWALKER, opponent.getId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        opponent.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return opponent.moveCards((Card)permanent, Zone.EXILED, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)BlotOutPredicate.instance);
    }

    private static enum BlotOutPredicate implements ObjectSourcePlayerPredicate<Permanent>
    {
        instance;


        public boolean apply(ObjectSourcePlayer<Permanent> input, Game game) {
            return ((Permanent)input.getObject()).getManaValue() >= game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_PLANESWALKER, input.getPlayerId(), input.getSource(), game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
        }
    }
}

