/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class BlueDragonEffect
extends ContinuousEffectImpl {
    BlueDragonEffect() {
        super(Duration.UntilYourNextTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.UnboostCreature);
        this.staticText = "until your next turn, target creature an opponent controls gets -3/-0, up to one other target creature gets -2/-0, and up to one other target creature gets -1/-0";
    }

    private BlueDragonEffect(BlueDragonEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BlueDragonEffect copy() {
        return new BlueDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power = -3;
        int affectedTargets = 0;
        for (Target target : source.getTargets()) {
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null && permanent.isCreature(game)) {
                permanent.addPower(power);
                ++affectedTargets;
            }
            ++power;
        }
        return affectedTargets > 0;
    }
}

