/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BlueMagesCaneEffect
extends OneShotEffect {
    BlueMagesCaneEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target instant or sorcery card from defending player's graveyard. If you do, copy it. You may cast the copy by paying {3} rather than paying its mana cost.";
    }

    private BlueMagesCaneEffect(BlueMagesCaneEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlueMagesCaneEffect copy() {
        return new BlueMagesCaneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        Card copiedCard = game.copyCard(card, source, source.getControllerId());
        if (!controller.chooseUse(Outcome.Benefit, "Cast " + copiedCard.getName() + " by paying {3}?", source, game)) {
            return false;
        }
        CardUtil.castSingle((Player)controller, (Ability)source, (Game)game, (Card)copiedCard, (ManaCostsImpl)new ManaCostsImpl("{3}"));
        return true;
    }
}

