/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BoingEffect
extends OneShotEffect {
    BoingEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then roll a six-sided die. If the result is 3 or less, scry a number of cards equal to the result";
    }

    private BoingEffect(BoingEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoingEffect copy() {
        return new BoingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        if (result <= 3) {
            player.scry(result, source, game);
        }
        return true;
    }
}

