/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BoldPlagiaristEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BoldPlagiaristTriggeredAbility
extends TriggeredAbilityImpl {
    BoldPlagiaristTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoldPlagiaristEffect());
    }

    private BoldPlagiaristTriggeredAbility(BoldPlagiaristTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(event.getPlayerId())) {
            return false;
        }
        this.getEffects().setValue("counterType", (Object)event.getData());
        this.getEffects().setValue("counterAmount", (Object)event.getAmount());
        this.getEffects().setValue("playerId", (Object)event.getPlayerId());
        return true;
    }

    public BoldPlagiaristTriggeredAbility copy() {
        return new BoldPlagiaristTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever an opponent puts one or more counters on a creature they control, they put the same number and kind of counters on {this}.";
    }
}

