/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BombSquadDamgeEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BombSquadTriggeredAbility
extends TriggeredAbilityImpl {
    public BombSquadTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BombSquadDamgeEffect(), false);
        this.setTriggerPhrase("Whenever a creature has four or more fuse counters on it, ");
    }

    private BombSquadTriggeredAbility(BombSquadTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BombSquadTriggeredAbility copy() {
        return new BombSquadTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getData().equals(CounterType.FUSE.getName()) && StaticFilters.FILTER_PERMANENT_CREATURE.match((Object)(permanent = game.getPermanent(event.getTargetId())), game) && 4 <= permanent.getCounters(game).getCount(CounterType.FUSE)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }
}

