/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BondOfPassionEffect
extends OneShotEffect {
    BondOfPassionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of target creature until end of turn. Untap that creature. It gains haste until end of turn. {this} deals 2 damage to any other target.";
    }

    private BondOfPassionEffect(BondOfPassionEffect effect) {
        super((OneShotEffect)effect);
    }

    public BondOfPassionEffect copy() {
        return new BondOfPassionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent2;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            game.processAction();
            permanent.untap(game);
            effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        if ((permanent2 = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            permanent2.damage(2, source.getSourceId(), source, game);
        } else {
            Player player = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
            if (player != null) {
                player.damage(2, source.getSourceId(), source, game);
            }
        }
        return true;
    }
}

