/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BoneDancerEffect
extends OneShotEffect {
    BoneDancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "put the top creature card of defending player's graveyard onto the battlefield under your control";
    }

    private BoneDancerEffect(BoneDancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoneDancerEffect copy() {
        return new BoneDancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && defendingPlayer != null) {
            Card lastCreatureCard = null;
            for (Card card : defendingPlayer.getGraveyard().getCards(game)) {
                if (!card.isCreature(game)) continue;
                lastCreatureCard = card;
            }
            if (lastCreatureCard != null) {
                controller.moveCards(lastCreatureCard, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

