/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;

enum BoneMaskEffectPreventionApplier implements PreventNextDamageFromChosenSourceEffect.ApplierOnPrevention
{
    instance;


    public boolean apply(PreventionEffectData data, Target target, GameEvent event, Ability source, Game game) {
        if (data == null || data.getPreventedDamage() <= 0) {
            return false;
        }
        int prevented = data.getPreventedDamage();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, prevented);
        controller.moveCards(cards, Zone.EXILED, source, game);
        return true;
    }

    public String getText() {
        return "Exile cards from the top of your library equal to the damage prevented this way";
    }
}

