/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.Dinosaur31Token;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BoneahoardDracosaurEffect
extends OneShotEffect {
    BoneahoardDracosaurEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top two cards of your library. You may play them this turn. If you exiled a land card this way, create a 3/1 red Dinosaur creature token. If you exiled a nonland card this way, create a Treasure token.";
    }

    private BoneahoardDracosaurEffect(BoneahoardDracosaurEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoneahoardDracosaurEffect copy() {
        return new BoneahoardDracosaurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, 2);
        if (cards.isEmpty()) {
            return true;
        }
        UUID exileId = CardUtil.getExileZoneId((String)("BonehoardDragon::" + source.getSourceId() + "::" + game.getTurn()), (Game)game);
        String exileName = CardUtil.getSourceIdName((Game)game, (Ability)source) + " turn:" + game.getTurnNum();
        controller.moveCardsToExile(cards, source, game, true, exileId, exileName);
        ExileZone zone = game.getExile().getExileZone(exileId);
        zone.setCleanupOnEndTurn(true);
        cards.removeIf(card -> !Zone.EXILED.equals((Object)game.getState().getZone(card.getId())));
        if (!cards.isEmpty()) {
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Collection)cards, game)), source);
        }
        boolean exiledLand = cards.stream().anyMatch(c -> c.isLand(game));
        boolean exiledNonLand = cards.stream().anyMatch(c -> !c.isLand(game));
        if (exiledLand) {
            new CreateTokenEffect((Token)new Dinosaur31Token()).apply(game, source);
        }
        if (exiledNonLand) {
            new CreateTokenEffect((Token)new TreasureToken()).apply(game, source);
        }
        return true;
    }
}

