/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BonusRoundDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    BonusRoundDelayedTriggeredAbility() {
        super((Effect)new CopyTargetStackObjectEffect(true, true, true), Duration.EndOfTurn, false);
    }

    private BonusRoundDelayedTriggeredAbility(BonusRoundDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public BonusRoundDelayedTriggeredAbility copy() {
        return new BonusRoundDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Until end of turn, whenever a player casts an instant or sorcery spell, that player copies it and may choose new targets for the copy";
    }
}

