/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardInYourGraveyard;

class BoonweaverGiantEffect
extends OneShotEffect {
    BoonweaverGiantEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "you may search your graveyard, hand, and/or library for an Aura card and put it onto the battlefield attached to {this}. If you search your library this way, shuffle.";
    }

    private BoonweaverGiantEffect(BoonweaverGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoonweaverGiantEffect copy() {
        return new BoonweaverGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInYourGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        UUID sourcePermanentId = sourcePermanent == null ? null : sourcePermanent.getId();
        FilterCard filter = new FilterCard("Aura card");
        filter.add((Predicate)SubType.AURA.getPredicate());
        filter.add((Predicate)new AuraCardCanAttachToPermanentId(sourcePermanentId));
        Card card = null;
        if (controller.chooseUse(Outcome.Neutral, "Search your graveyard for an Aura card?", source, game)) {
            target = new TargetCardInYourGraveyard(filter);
            if (controller.choose(Outcome.PutCardInPlay, (Cards)controller.getGraveyard(), (TargetCard)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null && controller.chooseUse(Outcome.Neutral, "Search your Hand for an Aura card?", source, game)) {
            target = new TargetCardInHand(filter);
            if (controller.choose(Outcome.PutCardInPlay, controller.getHand(), (TargetCard)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            target = new TargetCardInLibrary(filter);
            if (controller.searchLibrary((TargetCardInLibrary)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
            }
            controller.shuffleLibrary(source, game);
        }
        if (card != null) {
            if (sourcePermanent != null) {
                game.getState().setValue("attachTo:" + card.getId(), (Object)sourcePermanent);
            }
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            if (sourcePermanent != null) {
                return sourcePermanent.addAttachment(card.getId(), source, game);
            }
        }
        return true;
    }
}

