/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.AttacksIfAbleTargetEffect;
import mage.abilities.effects.common.combat.BlocksIfAbleTargetEffect;
import mage.abilities.effects.common.combat.CantAttackTargetEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BorosBattleshaperEffect
extends OneShotEffect {
    BorosBattleshaperEffect() {
        super(Outcome.Benefit);
        this.staticText = "up to one target creature attacks or blocks this combat if able and up to one target creature can't attack or block this combat";
    }

    private BorosBattleshaperEffect(BorosBattleshaperEffect effect) {
        super((OneShotEffect)effect);
    }

    public BorosBattleshaperEffect copy() {
        return new BorosBattleshaperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature2;
        Permanent creature1 = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature1 != null) {
            BlocksIfAbleTargetEffect effect;
            if (game.getOpponents(creature1.getControllerId()).contains(game.getActivePlayerId())) {
                effect = new BlocksIfAbleTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature1.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            } else {
                effect = new AttacksIfAbleTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature1.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        if ((creature2 = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            if (game.getOpponents(creature2.getControllerId()).contains(game.getActivePlayerId())) {
                CantBlockTargetEffect effect = new CantBlockTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature2.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            } else {
                CantAttackTargetEffect effect = new CantAttackTargetEffect(Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature2.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

