/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.b.BorosStrikeCaptainCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BorosStrikeCaptainEffect
extends OneShotEffect {
    BorosStrikeCaptainEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. During any turn you attacked with three or more creatures, you may play that card";
    }

    private BorosStrikeCaptainEffect(BorosStrikeCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public BorosStrikeCaptainEffect copy() {
        return new BorosStrikeCaptainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false, (UUID)player.getId(), (Condition)BorosStrikeCaptainCondition.instance);
        return true;
    }
}

