/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.EscalateAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.target.TargetPermanent;

public final class BorrowedHostility
extends CardImpl {
    private static final FilterCreaturePermanent filterBoost = new FilterCreaturePermanent("creature to get +3/+0");
    private static final FilterCreaturePermanent filterFirstStrike = new FilterCreaturePermanent("creature to gain first strike");

    public BorrowedHostility(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}");
        this.addAbility((Ability)new EscalateAbility((Cost)new ManaCostsImpl("{3}")));
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(2);
        BoostTargetEffect effect = new BoostTargetEffect(3, 0, Duration.EndOfTurn);
        effect.setText("Target creature gets +3/+0 until end of turn");
        this.getSpellAbility().addEffect((Effect)effect);
        this.getSpellAbility().addTarget(new TargetPermanent((FilterPermanent)filterBoost).withChooseHint("gets +3/+0 until end of turn"));
        effect = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("Target creature gains first strike until end of turn");
        Mode mode = new Mode((Effect)effect);
        mode.addTarget(new TargetPermanent((FilterPermanent)filterFirstStrike).withChooseHint("gains first strike until end of turn"));
        this.getSpellAbility().addMode(mode);
    }

    private BorrowedHostility(BorrowedHostility card) {
        super((CardImpl)card);
    }

    public BorrowedHostility copy() {
        return new BorrowedHostility(this);
    }
}

