/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class BottleCapBlastEffect
extends OneShotEffect {
    BottleCapBlastEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 5 damage to any target. If excess damage was dealt to a permanent this way, create that many tapped Treasure tokens.";
    }

    private BottleCapBlastEffect(BottleCapBlastEffect effect) {
        super((OneShotEffect)effect);
    }

    public BottleCapBlastEffect copy() {
        return new BottleCapBlastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Player player = game.getPlayer(targetId);
        if (player != null) {
            player.damage(5, source, game);
            return true;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(5, source, game);
        if (excess > 0) {
            new TreasureToken().putOntoBattlefield(excess, game, source, source.getControllerId(), true, false);
        }
        return true;
    }
}

