/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BottledCloisterReturnEffect
extends OneShotEffect {
    BottledCloisterReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all cards you own exiled with {this} to your hand, then draw a card";
    }

    private BottledCloisterReturnEffect(BottledCloisterReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public BottledCloisterReturnEffect copy() {
        return new BottledCloisterReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl(exileZone.getCards(game));
        cards.removeIf(uuid -> !player.getId().equals(game.getOwnerId(uuid)));
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        player.drawCards(1, source, game);
        return true;
    }
}

