/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.MapToken;
import mage.players.Player;

class BrackishBlunderEffect
extends OneShotEffect {
    BrackishBlunderEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature to its owner's hand. If it was tapped, create a Map token";
    }

    private BrackishBlunderEffect(BrackishBlunderEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrackishBlunderEffect copy() {
        return new BrackishBlunderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        boolean tapped = permanent.isTapped();
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (tapped) {
            new MapToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

