/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BrainGorgersCounterSourceEffect
extends OneShotEffect {
    BrainGorgersCounterSourceEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "any player may sacrifice a creature. If a player does, counter {this}";
    }

    private BrainGorgersCounterSourceEffect(BrainGorgersCounterSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrainGorgersCounterSourceEffect copy() {
        return new BrainGorgersCounterSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                cost.clearPaid();
                Player player = game.getPlayer(playerId);
                if (player == null || !cost.canPay(source, source, player.getId(), game) || !player.chooseUse(this.outcome, "Sacrifice a creature to counter " + sourceObject.getIdName() + '?', source, game) || !cost.pay(source, game, source, player.getId(), false, null)) continue;
                game.informPlayers(player.getLogName() + " sacrifices a creature to counter " + sourceObject.getIdName() + '.');
                Spell spell = game.getStack().getSpell(source.getSourceId());
                if (spell == null) continue;
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

