/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.TargetPermanent;

public final class BranchingBolt
extends CardImpl {
    private static final FilterCreaturePermanent filterNotFlying = new FilterCreaturePermanent("creature without flying");

    public BranchingBolt(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{R}{G}");
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new DamageTargetEffect(3));
        this.getSpellAbility().addTarget(new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_FLYING).withChooseHint("deals 3 damage, without flying"));
        Mode mode = new Mode((Effect)new DamageTargetEffect(3));
        mode.addTarget(new TargetPermanent((FilterPermanent)filterNotFlying).withChooseHint("deals 3 damage, without flying"));
        this.getSpellAbility().addMode(mode);
    }

    private BranchingBolt(BranchingBolt card) {
        super((CardImpl)card);
    }

    public BranchingBolt copy() {
        return new BranchingBolt(this);
    }

    static {
        filterNotFlying.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

