/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BrandOfIllOmenEffect
extends ContinuousRuleModifyingEffectImpl {
    BrandOfIllOmenEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Enchanted creature's controller can't cast creature spells";
    }

    private BrandOfIllOmenEffect(BrandOfIllOmenEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BrandOfIllOmenEffect copy() {
        return new BrandOfIllOmenEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast creature spells (" + mageObject.getLogName() + " on the battlefield).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent brand = game.getPermanent(source.getSourceId());
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject != null && brand != null && brand.getAttachedTo() != null) {
            UUID enchantedController = game.getPermanent(brand.getAttachedTo()).getControllerId();
            return Objects.equals(enchantedController, event.getPlayerId()) && sourceObject.isCreature(game);
        }
        return false;
    }
}

